(function( $ ) {
    'use strict';
    var VisualFogAnimation = {
        initFog: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualFogAnimation.initFogWidget);
        },
        initFogWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var fogAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        fogAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                fogAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = fogAnimationArgs.marvy_enable_fog_animation;
                    settings.highlightColor = fogAnimationArgs.marvy_fog_animation_highlight_color;
                    settings.midtoneColor = fogAnimationArgs.marvy_fog_animation_midtone_color;
                    settings.lowlightColor = fogAnimationArgs.marvy_fog_animation_lowlight_color;
                    settings.baseColor = fogAnimationArgs.marvy_fog_animation_base_color;
                    settings.blurFactor = fogAnimationArgs.marvy_fog_animation_blur_factor;
                    settings.zoom = fogAnimationArgs.marvy_fog_animation_zoom;
                    settings.speed = fogAnimationArgs.marvy_fog_animation_speed;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_fog_animation");
                settings.highlightColor = $scope.data("marvy_fog_animation_highlight_color");
                settings.midtoneColor = $scope.data("marvy_fog_animation_midtone_color");
                settings.lowlightColor = $scope.data("marvy_fog_animation_lowlight_color");
                settings.baseColor = $scope.data("marvy_fog_animation_base_color");
                settings.blurFactor = $scope.data("marvy_fog_animation_blur_factor");
                settings.zoom = $scope.data("marvy_fog_animation_zoom");
                settings.speed = $scope.data("marvy_fog_animation_speed");
            }

            if (settings.switch) {
                fogAnimation(target, settings, sectionId);
            }
        }
    };

    function fogAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-fog-section-" + sectionId);
        if (checkElement.length >= 0) {

            var fog_div = document.createElement('div');
            fog_div.classList.add("marvy-fog-section-" + sectionId);

            document.querySelector(target).appendChild(fog_div);
            document.querySelector(target).classList.add("marvy-custom-fog-animation-section-" + sectionId);

            // Set Z-index for section container
            var fogZindex = document.querySelector('.marvy-custom-fog-animation-section-'+sectionId+' .elementor-container');
            fogZindex.style.zIndex = '99';

            // Set min height
            var fogMinHeight = document.querySelector(".elementor-element-"+sectionId);
            fogMinHeight.closest('.elementor-top-section').style.minHeight = "400px";

            VANTA.FOG({
                el: ".marvy-fog-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 400.00,
                scale: 1.00,
                scaleMobile: 1.00,
                highlightColor: settings.highlightColor,
                midtoneColor: settings.midtoneColor,
                lowlightColor: settings.lowlightColor,
                baseColor: settings.baseColor,
                blurFactor: settings.blurFactor,
                speed: settings.speed,
                zoom: settings.zoom
            });

        }
        return true;
    }

    $( window ).on('elementor/frontend/init', VisualFogAnimation.initFog);
})( jQuery );